/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.item;

import com.eeeab.eeeabsmobs.sever.entity.impl.effect.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.entity.impl.effect.EntityGuardianBlade;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.MTUtils;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemGuardianAxe
extends AxeItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static final UUID GUARDIAN_BASE_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("BFF48EEA-FF5B-45B6-88FC-3C8FBBAF78FA");

    public ItemGuardianAxe(Tier tier, float attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(attackDamageModifier + tier.m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeedModifier, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(GUARDIAN_BASE_KNOCKBACK_RESISTANCE_UUID, "Weapon modifier", 0.1, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Player player;
        ItemStack itemStack;
        int i;
        if (livingEntity instanceof Player && (i = this.m_8105_(itemStack = (player = (Player)livingEntity).m_6298_(stack)) - remainingUseDuration) >= 20 && level.f_46443_) {
            this.doWeaponEffect(level, player, Mth.m_14045_((int)((int)Math.round((double)i * 0.1)), (int)3, (int)6));
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int remainingUseDuration) {
        Player player;
        ItemStack itemStack;
        int i;
        if (entity instanceof Player && (i = this.m_8105_(itemStack = (player = (Player)entity).m_6298_(stack)) - remainingUseDuration) >= 20) {
            InteractionHand hand = player.m_7655_();
            player.m_21011_(hand, true);
            int round = (int)Math.round((double)i * 0.1);
            this.doSpawnBlade(player, Mth.m_14045_((int)round, (int)3, (int)6), player.m_217043_().m_188501_());
            player.m_36335_().m_41524_((Item)this, 100);
            player.m_5496_(SoundEvents.f_11913_, 1.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
            EntityCameraShake.cameraShake(level, player.m_20182_(), 8.0f, 0.2f + (float)round * 0.01f, 0, 20);
        }
    }

    private void doSpawnBlade(Player player, int spawnQuantity, float offset) {
        for (int i = 0; i < spawnQuantity; ++i) {
            float f1 = (float)((double)player.m_146908_() + (double)(((float)i + offset) * (float)Math.PI) * (2.0 / (double)spawnQuantity));
            double x = player.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5;
            double y = player.m_20186_();
            double z = player.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5;
            EntityGuardianBlade blade = new EntityGuardianBlade(player.f_19853_, (LivingEntity)player, x, y, z, f1, false);
            player.f_19853_.m_7967_((Entity)blade);
        }
    }

    private void doWeaponEffect(Level level, Player player, int spawnQuantity) {
        RandomSource random = player.m_217043_();
        for (int i = 0; i < spawnQuantity; ++i) {
            double x = player.m_20185_() + random.m_188583_();
            double y = player.m_20186_() + (double)0.1f;
            double z = player.m_20189_() + random.m_188583_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_175827_, x, y, z, 0.0, 0.01, 0.0);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity hitEntity, LivingEntity livingEntity) {
        if (!hitEntity.f_19853_.f_46443_) {
            hitEntity.m_5496_((SoundEvent)SoundInit.GIANT_AXE_HIT.get(), 1.0f, 0.2f);
        }
        return super.m_7579_(itemStack, hitEntity, livingEntity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add(MTUtils.UNABLE_BREAKS);
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            tooltip.add(MTUtils.simpleShiftDownText(null, MTUtils.STYLE_GREEN));
        } else {
            tooltip.add(MTUtils.simpleWeaponText("guardian_axe", MTUtils.STYLE_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }
}

